/*global define */
define(["lib/Zoot"],
function (Z) {
	"use strict";

	
	function constructKeyMap(self, args) {
		self.keyMap = {}; 	// map from key -> array of layers that are triggered by that key
		self.mutexMap = {};	// map from parentLayer -> array of keys are in the same mutually exclusive group.
							// this is used to turn off other latches when they exist in the same mutex group.

		args.forEachLayerInTreeLegacy(function (lay) {
			var keyTrigger0 = lay.getKeyTriggerKey();

			/* var pp = lay.getParentLayer();
			console.logToUser("examining " + lay.getName() + "--" + lay.getId() + " --> " + lay.getSource().getName() + " *** " + keyTrigger0 +
							  ", parentLayer: " + pp + " " + (pp ? pp.getName() : "")); */

			if (keyTrigger0) {
				var parentLayer = lay.getParentLayer(),
					bHideOthersWhenTriggered = lay.getHideOthersWhenTriggered();
				
				if (parentLayer && bHideOthersWhenTriggered) {
					var parentLayerId = parentLayer.getId();
					self.mutexMap[parentLayerId] = self.mutexMap[parentLayerId] || {};
					self.mutexMap[parentLayerId][keyTrigger0] = true;
				}
				
				lay.setTriggerable(bHideOthersWhenTriggered);

				if (!self.keyMap.hasOwnProperty(keyTrigger0)) {
					self.keyMap[keyTrigger0] = {springA:[], latchA:[], latchParentsA:[]};
				}
				var keyMap = self.keyMap[keyTrigger0];
				if (lay.getTriggerUsesLatch()) {
					keyMap.latchA.push(lay);
					keyMap.latchParentsA.push(parentLayer);
				} else {
					keyMap.springA.push(lay);
				}
			}
		});
	}

	function getKeyGraphId(inKeyName) {
		return Z.keyCodes.getKeyGraphId(Z.keyCodes.getKeyCode(inKeyName));
	}

	function isKeyDown(args, inKeyName) {
		return args.getParamEventValue("KeyboardInput", getKeyGraphId(inKeyName)) || 0;
	}
	
	function getTakeGroupName(inKeyName, inIsLatchedB) {
		var prefix = inIsLatchedB ? "Trigger/Latch/" : "Trigger/Spring/";
		return prefix + inKeyName;
	}

	function publishKeyReplacements(self, args) {
		var keyName, keyDown, paramOutputKey = args.getParamEventOutputKey("KeyboardInput"), maxKeyValue0,
			springValueB, latchedValueB, maxValueChangedB, repeatB;
		
		for (keyName in self.keyMap) {
			if (self.keyMap.hasOwnProperty(keyName)) {
				self.keyStatesA[keyName] = self.keyStatesA[keyName] || {};
				
				var keyMap = self.keyMap, keyStatesA = self.keyStatesA,
					keyState = keyStatesA[keyName], keyGraphId = getKeyGraphId(keyName);

				keyDown = isKeyDown(args, keyName);

				// Get the max value from the event graph directly, since it's live.  -jacquave
				maxKeyValue0 = args.eventGraph.getMaxValue(keyGraphId);
				repeatB = args.eventGraph.getValue(keyGraphId + "\Repeat");
				
				// To trigger quick keydowns that happen between frames, we track the last max value
				// for the key and enable the trigger for the next frame.  -jacquave
				if (keyState.lastMaxValue === undefined) {
					// In order to deal with reseting the rehearsal state, we set this
					// to be valid, then can use the comparison with the last max value correctly below.  -jacquave
					keyState.lastMaxValue = maxKeyValue0 || 0;
				}
				maxValueChangedB = (maxKeyValue0 > keyState.lastMaxValue);
				springValueB = (keyDown || maxValueChangedB) || false;
				
				latchedValueB = keyState.wasLatchedB;
				if (!repeatB && maxValueChangedB && (!keyState.wasRepeatB || keyDown)) {
					latchedValueB = !latchedValueB;
					
					if (latchedValueB) {
						// Unlatch siblings that are in the same latched mutex group.
						if (keyMap[keyName].latchParentsA.length) {
							var latchParentKey, latchParent, latchParentId, siblingKeyName;
							for (latchParentKey in keyMap[keyName].latchParentsA) {
								if (keyMap[keyName].latchParentsA.hasOwnProperty(latchParentKey)) {
									latchParent = keyMap[keyName].latchParentsA[latchParentKey];
									latchParentId = latchParent.getId();
									for (siblingKeyName in self.mutexMap[latchParentId]) {
										if (self.mutexMap[latchParentId].hasOwnProperty(siblingKeyName) &&
										   	keyStatesA[siblingKeyName]) {
											keyStatesA[siblingKeyName].wasLatchedB = false;
										}
									}
								}
							}
						}
					}
				}

				var springValidB = (springValueB && self.keyMap[keyName].springA.length),
					latchValidB = (latchedValueB && self.keyMap[keyName].latchA.length),
					springKey = paramOutputKey + "Trigger/Spring/" + keyName, 
					triggerKey = paramOutputKey + "Trigger/Latch/" + keyName;
				
				if (springValidB) {
					args.setEventGraphParamRecordingValid("KeyboardInput", getTakeGroupName(keyName, false));
				}
				if (latchValidB) {
					args.setEventGraphParamRecordingValid("KeyboardInput", getTakeGroupName(keyName, true));
				}
				
				// Publish the spring/latch values.
				if (springValidB || args.eventGraph.hasGraph(springKey)) {
					args.eventGraph.publish1D(springKey, args.currentTime, springValueB ? 1 : 0, true);			
				}
				if (latchValidB || args.eventGraph.hasGraph(triggerKey)) {
					args.eventGraph.publish1D(triggerKey, args.currentTime, latchedValueB ? 1 : 0, true);			
				}
				
				keyState.wasLatchedB = latchedValueB;
				keyState.wasRepeatB = repeatB;
				keyState.wasSpringedB = springValueB;
				keyState.lastMaxValue = maxKeyValue0 || 0;
			}
		}
	}

	function triggerReplacements(self, inLayersA) {
		var priority = 1.0;
		
		inLayersA.forEach( function (inLayer) {
			inLayer.trigger(priority); // show this layer, and hide siblings if mutex
			//console.logToUser("triggering " + layers[i].getName() + " via key " + keyName);			
		});
	}	
	
	function chooseKeyReplacements(self, args) {
		var keyName, paramOutputKey = args.getParamEventOutputKey("KeyboardInput");

		for (keyName in self.keyMap) {
			if (self.keyMap.hasOwnProperty(keyName)) {
				if (args.getParamEventValue("KeyboardInput", paramOutputKey + "Trigger/Spring/" + keyName, getTakeGroupName(keyName, false))) {
					triggerReplacements(self, self.keyMap[keyName].springA);
				}
				if (args.getParamEventValue("KeyboardInput", paramOutputKey + "Trigger/Latch/" + keyName, getTakeGroupName(keyName, true))) {
					triggerReplacements(self, self.keyMap[keyName].latchA);
				}
			}
		}
	}	

	return {
		about:			"$$$/private/animal/Behavior/KeyReplacer/About=Keyboard Triggers, (c) 2014.",
		description: 	"$$$/animal/Behavior/KeyReplacer/Desc=Hides and shows artwork based on keyboard shortcuts",
		uiName:  		"$$$/animal/Behavior/KeyReplacerOld/UIName=Keyboard Triggers (obsolete)",
		defaultArmedForRecordOn: true,
		hideInBehaviorList: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{
				    id: "KeyboardInput", type: "eventGraph", uiName: "$$$/animal/Behavior/KeyReplacer/Parameter/KeyboardInput=Keyboard Input", inputKeysArray: ["Keyboard/"],
			        outputKeyTraits: {
		                takeGroupsArray: [
			                {
			                    id: "Trigger/Spring/*",
								uiName : "$$$/animal/Behavior/KeyReplacer/takeGroupName={keyName:*}"
							},
			                {
			                    id: "Trigger/Latch/*",
								uiName : "$$$/animal/Behavior/KeyReplacer/takeGroupNameLatched={keyName:*} Latched"
							}
		                ]
			        },
				    uiToolTip: "$$$/animal/Behavior/KeyReplacer/Parameter/KeyboardInput/tooltip=Keyboard input used to hide and show artwork", defaultArmedForRecordOn: true
				}
			];
		},

		onCreateBackStageBehavior: function (/*self*/) {
			return { order: 0.0, importance : 0.0 };	// must come before Cycle Layers or any other behavior that reads triggers
		},

		onCreateStageBehavior: function (self, args) {
			constructKeyMap(self, args);
		},

		onResetRehearsalData : function (self) {
			delete self.keyStatesA;
		},

		onFilterLiveInputs: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var inputParamId = "KeyboardInput", inputLiveB = args.isParamEventLive(inputParamId);
			
			if (inputLiveB) {
				if (!self.keyStatesA) {
					self.keyStatesA = [];
				}
				publishKeyReplacements(self, args);
			}
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage	
			chooseKeyReplacements(self, args);
		}

	}; // end of object being returned
});
